﻿using com.mirle.ibg3k0.sc.App;
using com.mirle.ibg3k0.sc.Data.VO;
using NLog;
using System;
using System.Windows;


namespace BlockControl_3._0_WPF.frm_Help
{


    /// <summary>
    /// frm_TipMessage.xaml 的互動邏輯
    /// </summary>
    public partial class frm_TipMessage_OK : Window
    {
        SCApplication scApp = null;
        private static Logger logger = LogManager.GetCurrentClassLogger();
        protected static Logger logger_SystemError = LogManager.GetLogger("SystemErrorLogger");


        public frm_TipMessage_OK()
        {
            InitializeComponent();
        }

        public frm_TipMessage_OK(string msg)
        {
            InitializeComponent();
            tbk_Message.Text = msg;
            btn_Yes.Focus();
        }

        public void setMessage(string msg)
        {
            tbk_Message.Text = msg;
        }

        private void btn_Yes_Click(object sender, RoutedEventArgs e)
        {
            this.DialogResult = true;
        }

        private void btn_No_Click(object sender, RoutedEventArgs e)
        {
            this.DialogResult = false;
        }

        private void DragMoveFrom_FromContent(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            try
            {
                this.DragMove();
            }
            catch (Exception ex)
            {
                logger_SystemError.Error(ex, "Exception");
            }
        }

        private void Window_Closing(object sender, System.ComponentModel.CancelEventArgs e)
        {
            e.Cancel = true;
            this.Visibility = Visibility.Hidden;
        }

        public void setMessage1(string msg)
        {
            try
            {
                if (scApp == null) { scApp = SCApplication.getInstance(); }
                if (scApp != null)
                {
                    MainAlarm ma = scApp.AlarmBLL.getMainAlarmByCode(msg);
                    if (ma != null)
                    {
                        tbk_Message.Text = ma.DESCRIPTION;
                    }
                    else
                    {
                        tbk_Message.Text = string.Empty;
                    }
                }
            }
            catch (Exception ex)
            {
                logger_SystemError.Error(ex, "Exception");
            }
        }
    }
}
