﻿//*********************************************************************************
//      SCUtility.cs
//*********************************************************************************
// File Name: SCUtility.cs
// Description: ScriptControl 共用工具元件
//
//(c) Copyright 2014, MIRLE Automation Corporation
//
// Date          Author         Request No.    Tag     Description
// ------------- -------------  -------------  ------  -----------------------------
//**********************************************************************************
using System;
using System.Collections.Generic;
using System.Configuration;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using com.mirle.ibg3k0.bcf.Common;
using com.mirle.ibg3k0.sc.App;
using System.Data;
using System.Reflection;
using NLog;
using com.mirle.ibg3k0.stc.Data.SecsData;
using com.mirle.ibg3k0.bcf.Controller;
using com.mirle.ibg3k0.sc.Data.VO;
using System.Collections;
using System.Diagnostics;
using com.mirle.ibg3k0.Utility.ul.Data;
using com.mirle.ibg3k0.WpfTools.Data.VO;
using System.Text.RegularExpressions;

namespace com.mirle.ibg3k0.sc.Common
{
    public class SCUtility
    {
        private static Logger logger = LogManager.GetCurrentClassLogger();
        private static Logger SECSMsgLogger = LogManager.GetLogger("SECSMsgLogger");
        private static Logger CSTInfoLogger = LogManager.GetLogger("CSTInfoLogger");
        private static Logger OperationLogger = LogManager.GetLogger("OperationLogger");
        private static Logger HostLogger = LogManager.GetLogger("HostLogger");
        private static Logger logger_SystemError = LogManager.GetLogger("SystemErrorLogger");

        //private CommonInfo ci;

        //Transfer Type的feature
        public const String FUNCTION_FEATURE_EC = "HH";
        public const String FUNCTION_FEATURE_EC2 = "HP";
        public const String FUNCTION_FEATURE_EC3 = "HR";
        public const String FUNCTION_FEATURE_EC4 = "HD";
        public const String FUNCTION_FEATURE_EC5 = "HW";
        public const String FUNCTION_FEATURE_EC6 = "HS";
        public const String FUNCTION_FEATURE_EC7 = "HC";
        //Transfer Type
        public const String FUNCTION_TRANSDFERTYPE_SEND = "Send";
        public const String FUNCTION_TRANSDFERTYPE_RECEIVE = "Receive";
        private static string selectPLCTransferType(string function_name)
        {
            string type = string.Empty;
            if (function_name.Contains(FUNCTION_FEATURE_EC) || function_name.Contains(FUNCTION_FEATURE_EC2) ||
                function_name.Contains(FUNCTION_FEATURE_EC3) || function_name.Contains(FUNCTION_FEATURE_EC4) ||
                function_name.Contains(FUNCTION_FEATURE_EC5) || function_name.Contains(FUNCTION_FEATURE_EC6) ||
                function_name.Contains(FUNCTION_FEATURE_EC7))
            {
                type = FUNCTION_TRANSDFERTYPE_SEND;
            }
            else
            {
                type = FUNCTION_TRANSDFERTYPE_RECEIVE;
            }
            return type;
        }

        public static void SystemEventLog(string msg, EventLogEntryType type)
        {
            try
            {
                string src_name = "SC Application";
                if (!EventLog.SourceExists(src_name))
                {
                    EventLog.CreateEventSource(src_name, src_name);
                }
                EventLog eLog = new EventLog();
                eLog.Source = src_name;
                eLog.WriteEntry(msg, type);
            }
            catch (Exception ex) { logger_SystemError.Error(ex, "Exception"); }
        }

        public static Boolean isMatche(Object obj1, Object obj2)
        {
            return BCFUtility.isMatche(obj1, obj2);
        }

        public static Boolean isEmpty(Object obj)
        {
            return BCFUtility.isEmpty(obj);
        }

        public static String Trim(String source)
        {
            return Trim(source, false);
        }

        /// <summary>
        /// </summary>
        /// <param name="source"></param>
        /// <returns></returns>
        public static String TrimAndToUpper(String source)
        {
            return ToUpper(Trim(source, false), false);
        }

        public static String Trim(string source, Boolean rtnEmptyStr)
        {
            if (source == null) { return (rtnEmptyStr ? string.Empty : source); }
            return source.Trim();
        }

        /// <summary>
        /// </summary>
        /// <param name="source"></param>
        /// <param name="rtnEmptyStr"></param>
        /// <returns></returns>
        public static String ToUpper(string source, Boolean rtnEmptyStr)
        {
            if (source == null) { return (rtnEmptyStr ? string.Empty : source); }
            return source.ToUpper();
        }
        public static String FirstToUpper_ElseToLower(string source)
        {
            if (source == null || source == string.Empty) { return source; }
            source = source.Trim();
            return source[0].ToString().ToUpper() + source.Substring(1).ToLower();
        }

        public static String FillPadLeft(string source, char padChar, int length)
        {
            if (source == null) { return null; }
            return Trim(source).PadLeft(length, padChar);
        }

        public static String convert2SlotMapMES(string slotMap)
        {
            string rtnSlotMap = string.Empty;
            if (slotMap == null)
            {
                return rtnSlotMap;
            }
            rtnSlotMap = slotMap.Replace(SCAppConstants.CSTSlotMap.Not_Exist, SCAppConstants.X_FLAG.ToString());
            rtnSlotMap = rtnSlotMap.Replace(SCAppConstants.CSTSlotMap.Exist, SCAppConstants.O_FLAG.ToString());
            return rtnSlotMap;
        }

        public static void Fill(object LogicObject, DataRow Row)
        {
            Dictionary<string, PropertyInfo> props = new Dictionary<string, PropertyInfo>();
            foreach (PropertyInfo p in LogicObject.GetType().GetProperties())
                props.Add(p.Name, p);
            foreach (DataColumn col in Row.Table.Columns)
            {
                string name = col.ColumnName;
                if (Row[name] != DBNull.Value && props.ContainsKey(name))
                {
                    object item = Row[name];
                    PropertyInfo p = props[name];
                    if (p.PropertyType != col.DataType)
                        item = Convert.ChangeType(item, p.PropertyType);
                    p.SetValue(LogicObject, item, null);
                }
            }

        }

        /// <summary>
        /// 更改系統時間
        /// </summary>
        /// <param name="hostTime"></param>
        public static void updateSystemTime(DateTime hostTime)
        {
            SystemTime st = new SystemTime();
            st.FromDateTime(hostTime);
            SystemTime.SetSystemTime(ref st);
            SystemTime.GetSystemTime(ref st);
            logger.Info("Set System Time:{0}", st.ToDateTime().ToString(SCAppConstants.TimestampFormat_16));
        }

        public static string stringListToString(string tagS, List<String> sList)
        {
            StringBuilder sb = new StringBuilder();
            foreach (String str in sList)
            {
                sb.Append(str);
                if (tagS != null)
                {
                    sb.Append(tagS);
                }
            }
            return sb.ToString();
        }

        public static void secsActionRecordMsg(SCApplication scApp, Boolean isReceive, SXFY sxfy)
        {
            if (sxfy == null) { return; }
            StringBuilder sb = new StringBuilder();
            sb.AppendLine(string.Format("[{0}][{1}][{2}][{3}][{4}][{5}]", DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss.fff"),
                (isReceive ? "R" : "S"), sxfy.StreamFunction, sxfy.SystemByte, sxfy.W_Bit, sxfy.SECSAgentName));

            string msg = string.Format("{0}{1}", sb.ToString(), sxfy.GetType().Name);
            scApp.getEQObjCacheManager().CommonInfo.SECS_Msg = msg;

            SECSMsgLogger.Info(msg);

            string sDateTime = DateTime.Now.ToString(SCAppConstants.DateTimeFormat_23);
            Task.Run(() =>
            {
                setLogInfo_SECS(scApp, isReceive, sxfy, sDateTime);
            });
        }

        public static void secsActionRecordMsg(SCApplication scApp, Boolean isReceive, int systemByte, string secsAgentName,
            string msg)
        {
            StringBuilder sb = new StringBuilder();
            sb.AppendLine(string.Format("[{0}][{1}][{2}][{3}][{4}]", DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss.fff"),
                (isReceive ? "R" : "S"), systemByte, secsAgentName, msg));
            sb.AppendLine("[" + DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss.fff") + "] " + (isReceive ? "[R]" : "[S]") +
                "[" + msg + "]");
            scApp.getEQObjCacheManager().CommonInfo.SECS_Msg = sb.ToString();
            SECSMsgLogger.Info(sb.ToString());
        }

        /// <summary>
        /// Add by Allen
        /// </summary>
        /// <param name="scApp"></param>
        /// <param name="isReceive"></param>
        /// <param name="sxfy"></param>
        /// <param name="SB"></param>
        public static void jsecsActionRecordMsg(JSECS_Base.JSecs jsecs, Boolean isReceive, SecsMessage sxfy, UInt32 SB)
        {
            if (sxfy == null) { return; }
            if (scApp == null) { scApp = SCApplication.getInstance(); }
            StringBuilder sb = new StringBuilder();
            int S = 0, F = 0, W = 0;
            sxfy.GetSFW(ref S, ref F, ref W);
            sb.AppendLine(string.Format("[{0}][{1}][{2}][{3}][{4}][{5}]", DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss.fff"),
                (isReceive ? "R" : "S"), "S" + S.ToString() + "F" + F.ToString(), SB, W, scApp.getEQObjCacheManager().getLine().Line_ID));

            string msg = string.Format("{0}{1}", sb.ToString(), sxfy.GetType().Name);
            scApp.getEQObjCacheManager().CommonInfo.SECS_Msg = msg;

            SECSMsgLogger.Info(msg);

            string sDateTime = DateTime.Now.ToString(SCAppConstants.DateTimeFormat_23);
            // Task.Run(() =>
            // {
            //     setLogInfo_JSECS(jsecs, isReceive, sxfy, sDateTime, SB);
            // });
            setLogInfo_JSECS(jsecs, isReceive, sxfy, sDateTime, SB);

        }

        public static void actionRecordMsg(SCApplication scApp, String funID, String eqID, String msg, String result)
        {
            StringBuilder sb = new StringBuilder();
            String dateTime = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss.fff");
            sb.Append(String.Format("[{0}][{1}][{2}][{3}][{4}]", dateTime, funID, eqID, msg, result));
            scApp.getEQObjCacheManager().CommonInfo.Action_Msg = sb.ToString();
            SECSMsgLogger.Info(sb.ToString());
        }

        /// <summary>
        /// Add by Allen
        /// </summary>
        /// <param name="scApp"></param>
        /// <param name="isReceive"></param>
        /// <param name="sxfy"></param>
        /// <param name="sDateTime"></param>
        /// <param name="sb"></param>
        public static void setLogInfo_JSECS(JSECS_Base.JSecs jsecs, Boolean isReceive, SecsMessage sxfy, string sDateTime, UInt32 sb)
        {
            try
            {
                if (scApp == null) { scApp = SCApplication.getInstance(); }
                int s = 0, f = 0, w = 0;
                sxfy.GetSFW(ref s, ref f, ref w);
                string DevID = "";
                string context = "";
                int SB = (int)sb;
                sxfy.GetText(ref context, SECS.TextOption_Default);
                jsecs.GetHSMS().GetConfig(SECS.CN_DeviceID, ref DevID);
                JSECS_Log_Parser.JSECSLogPaser jSECSLogPaser = new JSECS_Log_Parser.JSECSLogPaser(sxfy);

                LogTitle_SECS logTitleTemp = new LogTitle_SECS()
                {
                    EQ_ID = scApp.getEQObjCacheManager().getLine().Line_ID,
                    SendRecive = isReceive ? FUNCTION_TRANSDFERTYPE_RECEIVE
                                            : FUNCTION_TRANSDFERTYPE_SEND,

                    Sx = s.ToString(),
                    Fy = f.ToString(),
                    DeviceID = DevID,
                    FunName = jSECSLogPaser.GetAlias() ?? string.Empty,
                    Message = jSECSLogPaser.ToLogString(jsecs) ?? context,
                    SystemByte = SB.ToString(),
                    LogType = SCAppConstants.LogType.SECS_ForHost.ToString()
                };
                logTitleTemp.Time = sDateTime;
                logUtility.addLogInfo(logTitleTemp);
            }
            catch (Exception ex)
            {
                logger_SystemError.Warn(ex, "Exception:");
            }
        }

        public static void setLogInfo_SECS(SCApplication scApp, Boolean isReceive, SXFY sxfy, string sDateTime)
        {
            try
            {

                if (isEmpty(sxfy.SECSAgentName)) return;

                com.mirle.ibg3k0.stc.Common.SECS.SECSAgent secsAgent = scApp.getBCFApplication().getSECSAgent(sxfy.SECSAgentName);
                string device_id = secsAgent == null ? string.Empty : secsAgent.DeviceID.ToString();

                string s = sxfy.getS().ToString();
                string f = sxfy.getF().ToString();

                LogTitle_SECS logTitleTemp = new LogTitle_SECS()
                {
                    EQ_ID = sxfy.SECSAgentName,
                    SendRecive = isReceive ? FUNCTION_TRANSDFERTYPE_RECEIVE
                                            : FUNCTION_TRANSDFERTYPE_SEND,

                    Sx = s,
                    Fy = f,
                    DeviceID = device_id,
                    FunName = sxfy.StreamFunctionName ?? string.Empty,
                    Message = sxfy.toSECSString(),
                    LogType = SCAppConstants.LogType.SECS_ForHost.ToString()
                };
                logTitleTemp.Time = sDateTime;
                logUtility.addLogInfo(logTitleTemp);
            }
            catch (Exception ex)
            {
                logger_SystemError.Warn(ex, "Exception:");
            }
        }

        public static void PLCActionRecordMsg(SCApplication scApp, string Node_ID, ref List<ValueWrite> vWriteList)
        {
            if (scApp == null)
                logger.Warn("scApp is null");
            if (Node_ID == null)
                logger.Warn("Node_ID is null");
            if (vWriteList == null)
                logger.Warn("vWriteList is null");

            if (scApp == null || Node_ID == null || vWriteList == null)
                return;

            scApp.getEQObjCacheManager().CommonInfo.PLC_Msg = string.Format("*************{0}*************", DateTime.Now.ToString());
            scApp.getEQObjCacheManager().CommonInfo.PLC_Msg = BCFUtility.writeEquipmentLog(Node_ID, vWriteList);
            vWriteList.Clear();
        }
        public static void PLCActionRecordMsg(SCApplication scApp, string Node_ID, ref List<ValueRead> vEventList)
        {
            scApp.getEQObjCacheManager().CommonInfo.PLC_Msg = string.Format("*************{0}*************", DateTime.Now.ToString());
            scApp.getEQObjCacheManager().CommonInfo.PLC_Msg = BCFUtility.writeEquipmentLog(Node_ID, vEventList);
            vEventList.Clear();
        }
        public static void PLCActionRecordMsg(SCApplication scApp, string Node_ID, ref List<ValueRead> vEventList, ref List<ValueWrite> vWriteList)
        {
            scApp.getEQObjCacheManager().CommonInfo.PLC_Msg = string.Format("*************{0}*************", DateTime.Now.ToString());
            scApp.getEQObjCacheManager().CommonInfo.PLC_Msg = BCFUtility.writeEquipmentLog(Node_ID, vEventList);
            scApp.getEQObjCacheManager().CommonInfo.PLC_Msg = BCFUtility.writeEquipmentLog(Node_ID, vWriteList);
            vEventList.Clear();
            vWriteList.Clear();
        }

        public static void RecordLog(Logger log, com.mirle.ibg3k0.sc.Data.PLC_Functions.PLC_FunBase fun, SCAppConstants.LogType log_type = SCAppConstants.LogType.PLC_ForEQ)
        {
            string msg = fun.ToString();
            StringBuilder builder = new StringBuilder();
            builder.AppendLine();
            builder.Append("-EQ ID :").AppendFormat("[{0}]", fun.EQ_ID).AppendLine();
            builder.Append("-Fun ID:").AppendFormat("[{0}]", fun.FunctionName).AppendLine();
            builder.Append(msg);
            log.Info(builder.ToString());
            SCUtility.setLogInfo_PLCForEQ(fun.EQ_ID, string.Empty, fun.FunctionName, msg, log_type, "");
        }

        static com.mirle.ibg3k0.Utility.ul.Data.LogUtility logUtility = com.mirle.ibg3k0.Utility.ul.Data.LogUtility.getInstance();

        //不記錄到分開的EQ LOG
        public static void RecordLog(com.mirle.ibg3k0.sc.Data.PLC_Functions.PLC_FunBase fun, string run_mode, SCAppConstants.LogType log_type = SCAppConstants.LogType.PLC_ForEQ)
        {
            string msg = fun.ToString();


            SCUtility.setLogInfo_PLCForEQ(fun.EQ_ID, string.Empty, fun.FunctionName, msg, log_type, run_mode);
        }
        public static void RecordLog(com.mirle.ibg3k0.sc.Data.PLC_Functions.PLC_FunBase fun, SCAppConstants.LogType log_type = SCAppConstants.LogType.PLC_ForEQ)
        {
            string msg = fun.ToString();

            SCUtility.setLogInfo_PLCForEQ(fun.EQ_ID, selectPLCTransferType(fun.FunctionName), fun.FunctionName, msg, log_type,
                SCAppConstants.RunMode.convert2Log(scApp.getEQObjCacheManager().getEfemEquipment().Run_Mode));
        }

        private static SCApplication scApp = null;
        const char CHAR_UNDERLINE = '_';
        public static void setLogInfo_PLCForEQ(string eq_id, string send_receive, string function_name, string msg, SCAppConstants.LogType log_type, string run_mode)
        {
            if (scApp == null) { scApp = SCApplication.getInstance(); }
            if (eq_id.Contains(CHAR_UNDERLINE))
            {
                eq_id = eq_id.Split(CHAR_UNDERLINE)[0];
            }
            int PortNo = eq_id.StartsWith("P0") ? int.Parse(eq_id.Substring(1)) : 0;

            EqptMap eqptMap = null;
            if (PortNo != 0)
            {
                eqptMap = scApp.EqptMapDao.getByEFEM_ID(scApp.BC_ID, SCAppConstants.EQPT_SYMBOL_EFEM);
            }
            else
            {
                eqptMap = scApp.EqptMapDao.getByEFEM_ID(scApp.BC_ID, eq_id);
            }

            string eq_real_id = eqptMap == null ? eq_id : eqptMap.EQPT_REAL_ID;

            if (PortNo != 0)
            {
                eq_real_id += "_P" + PortNo.ToString("00");
            }

            string replacement = ConfigurationManager.AppSettings["UI_MachineName"] ?? "";

            if (!string.IsNullOrEmpty(eq_real_id))
            {
                eq_real_id = Regex.Replace(eq_real_id, "EFEM", replacement);
            }

            LogTitle_PLC logTitleTemp = new LogTitle_PLC()
            {
                EQ_ID = eq_real_id + "_" + run_mode,
                LogType = log_type.ToString(),
                SendRecive = send_receive,
                FunName = function_name,
                Message = msg
            };

            Task.Run(() => logUtility.addLogInfo(logTitleTemp));
        }

        public static void setLogInfo_PLCForEQ(string eq_id, string send_receive, string function_name, string msg, string sDateTime)
        {
            if (scApp == null) { scApp = SCApplication.getInstance(); }
            if (eq_id.Contains(CHAR_UNDERLINE))
            {
                eq_id = eq_id.Split(CHAR_UNDERLINE)[0];
            }
            int PortNo = 0;
            EqptMap eqptMap = scApp.EqptMapDao.getByEFEM_ID(scApp.BC_ID, eq_id);
            string eq_real_id;
            if (eqptMap == null)
            {
                eq_real_id = eq_id;
            }
            else
            {
                eq_real_id = eqptMap.EQPT_REAL_ID.Trim();
                if (PortNo != 0)
                {
                    eq_real_id += "_P" + PortNo.ToString("00");
                }
            }

            LogTitle_PLC logTitleTemp = new LogTitle_PLC()
            {
                EQ_ID = eq_real_id,
                SendRecive = send_receive,
                FunName = function_name,
                Message = msg,
                LogType = SCAppConstants.LogType.PLC_ForEQ.ToString()
            };
            logTitleTemp.Time = sDateTime;

            Task.Run(() => logUtility.addLogInfo(logTitleTemp));
        }

        public static int convertToInt(int int1, int iStartIndex1, int iEndIndex1, int int2, int iStartIndex2, int iEndIndex2)
        {
            int shiftInt2 = int2 * (int)Math.Pow(2, 12);
            UInt16[] iArray1 = new UInt16[1] { (UInt16)int1 };
            UInt16[] iArray2 = new UInt16[1] { (UInt16)shiftInt2 };
            Boolean[] bArray1 = convertToBooleans(iArray1, 0, 0);
            Boolean[] bArray2 = convertToBooleans(iArray2, 0, 0);
            BitArray ResultArray = new BitArray(16);

            int boolCount = 0;
            foreach (Boolean b in bArray1)
            {
                ResultArray[boolCount] = bArray1[boolCount] | bArray2[boolCount];
                boolCount++;
            }

            //BitArray bitArray = new BitArray(16);
            //int j = 0;
            //for (int i = iStartIndex1; i < iEndIndex1; i++)
            //{
            //    bitArray[i] = bArray1[j];
            //    j++;
            //}
            //j = 0;
            //for (int i = iStartIndex2; i < iEndIndex2; i++)
            //{
            //    bitArray[i] = bArray2[j];
            //    j++;
            //}

            int[] intAry = new int[1];
            ResultArray.CopyTo(intAry, 0);
            return intAry[0];
        }

        public static Boolean[] convertToBooleans(UInt16[] dataTemp, int iStartIndex, int iEndIndex)
        {
            int[] rangeData = BCFUtility.getArrayRange(dataTemp, iStartIndex, iEndIndex);
            return (Boolean[])BCFUtility.convertInt2TextByType(16, Type.GetType("System.Boolean[]"), rangeData);
        }


        public static void ConvertPLCMsg(string functionName, string EQ_ID, string EQ_Real_ID, StringBuilder convertValue)
        {
            string sDateTime = DateTime.Now.ToString(SCAppConstants.DateTimeFormat_23);
            string sconvertValue = convertValue.ToString();

            Task.Run(() => { ConvertPLCMsgAsync(functionName, EQ_ID, EQ_Real_ID, sconvertValue, sDateTime); });
            convertValue.Clear();
        }

        protected static Logger convertPLClogger = LogManager.GetLogger("ConvertPLCLog");
        public static void ConvertPLCMsgAsync(string functionName, string EQ_ID, string EQ_Real_ID, string convertValue, string sDateTime)
        {
            //1.記錄到Total的Log
            convertPLClogger.Info(Environment.NewLine + "Trigger T:[{0}]{1}******************EQPT {2}:{3}******************{4}{5}{6}{7}"
                                                    , sDateTime
                                                    , Environment.NewLine
                                                    , EQ_ID
                                                    , EQ_Real_ID
                                                    , Environment.NewLine
                                                    , functionName
                                                    , Environment.NewLine
                                                    , convertValue);
            //2.記錄到個別EQ的Log
            recodeConvertPLCInfoForEq(functionName, EQ_ID.Trim(), convertValue, sDateTime);
            //3.呈現到畫面上的Log
            setLogInfo_PLCForEQ(EQ_ID, selectPLCTransferType(functionName), functionName, convertValue, sDateTime);
        }

        private static void recodeConvertPLCInfoForEq(string functionName, string EQ_ID, string convertValue, string sDateTime)
        {
            if (EQ_ID == SCAppConstants.EQPT_SYMBOL_EFEM)
            {
                convertPLClogger_EFEM.Info(Environment.NewLine +
                      "Trigger T:[{0}]{1}******************{2}******************{3}{4}"
                       , sDateTime, Environment.NewLine, functionName, Environment.NewLine, convertValue);
            }
            else if (EQ_ID == SCAppConstants.EQPT_SYMBOL_EQ1)
            {
                convertPLClogger_EQ1.Info(Environment.NewLine +
                       "Trigger T:[{0}]{1}******************{2}******************{3}{4}"
                        , sDateTime, Environment.NewLine, functionName, Environment.NewLine, convertValue);
            }
            else if (EQ_ID == SCAppConstants.EQPT_SYMBOL_EQ2)
            {
                convertPLClogger_EQ2.Info(Environment.NewLine +
                       "Trigger T:[{0}]{1}******************{2}******************{3}{4}"
                        , sDateTime, Environment.NewLine, functionName, Environment.NewLine, convertValue);
            }
            else if (EQ_ID == SCAppConstants.EQPT_SYMBOL_EQ3)
            {
                convertPLClogger_EQ3.Info(Environment.NewLine +
                       "Trigger T:[{0}]{1}******************{2}******************{3}{4}"
                        , sDateTime, Environment.NewLine, functionName, Environment.NewLine, convertValue);
            }
            else if (EQ_ID == SCAppConstants.EQPT_SYMBOL_EQ4)
            {
                convertPLClogger_EQ4.Info(Environment.NewLine +
                       "Trigger T:[{0}]{1}******************{2}******************{3}{4}"
                        , sDateTime, Environment.NewLine, functionName, Environment.NewLine, convertValue);
            }
        }

        protected static Logger convertPLClogger_EFEM = LogManager.GetLogger("ConvertPLCLog_EFEM");
        /// <summary>
        /// </summary>
        /// <param name=""></param>
        public static void ConvertPLCMsg_EFEM(string functionName, string Node_ID, Dictionary<string, string> convertValue, StringBuilder sb)
        {

            //convertPLClog.Info("*************{0}*************");
            sb.Clear();
            foreach (KeyValuePair<string, string> item in convertValue)
            {
                sb.AppendFormat("      {0} = {1}{2}", item.Key, item.Value, Environment.NewLine);
            }
            convertPLClogger_EFEM.Info(Environment.NewLine + "*****{0}*****{1}{2}", functionName, Environment.NewLine, sb.ToString());
            convertValue.Clear();

        }

        protected static Logger convertPLClogger_EQ1 = LogManager.GetLogger("ConvertPLCLog_EQ1");
        protected static Logger convertPLClogger_EQ2 = LogManager.GetLogger("ConvertPLCLog_EQ2");
        protected static Logger convertPLClogger_EQ3 = LogManager.GetLogger("ConvertPLCLog_EQ3");
        protected static Logger convertPLClogger_EQ4 = LogManager.GetLogger("ConvertPLCLog_EQ4");
        public static LogUtility LogUtility { get => logUtility; set => logUtility = value; }

        /// <summary>
        /// 在Type1 機台 執行FUN時發生錯誤後，顯示到畫面上
        /// </summary>
        /// <param name="errorFun"></param>
        public static void onFunErrorLog(string errorFun)
        {
            //BCFApplication.onErrorLog(string.Format("FUN:{0} Has error happend!!", errorFun));
        }

        public static String getPropertiesLength(object obj)
        {
            StringBuilder sb = new StringBuilder();
            var type = obj.GetType();

            // Get the PropertyInfo object:
            PropertyInfo[] properties = type.GetProperties();
            foreach (PropertyInfo property in properties)
            {

                if (property.PropertyType == typeof(string))
                {
                    String s;
                    if (property.GetValue(obj) != null)
                        s = property.GetValue(obj).ToString();
                    else
                        s = string.Empty;
                    sb.AppendFormat("{0}.length = '{1}'", property.Name, s.Length);
                    sb.AppendFormat("    {0}.value = '{1}'", property.Name, property.GetValue(obj));
                    sb.AppendLine();
                }
                else
                {
                    sb.AppendFormat("{0}.value = '{1}'", property.Name, property.GetValue(obj));
                    sb.AppendLine();
                }
            }
            return sb.ToString();
        }

        public static void TrimAllParameter(object obj)
        {
            try
            {
                if (obj == null) { return; }
                var type = obj.GetType();
                // Get the PropertyInfo object:
                PropertyInfo[] properties = type.GetProperties();
                foreach (PropertyInfo property in properties)
                {

                    if (property.PropertyType == typeof(string))
                    {
                        if (property.GetValue(obj) != null)
                        {
                            String temp = property.GetValue(obj).ToString().Trim();
                            property.SetValue(obj, temp);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                logger_SystemError.Error(ex, "Exception");
            }
        }

        public static string ShowCallerInfo(StackTrace st, string remark)
        {
            StringBuilder sb = new StringBuilder();
            try
            {
                if (st == null)
                {
                    st = new StackTrace(true);
                }
                sb.AppendLine(new string('=', 80));
                sb.AppendLine(string.Format("Caller Remark: {0}", remark));
                StackFrame sf = st.GetFrame(1);
                MethodBase mb = sf.GetMethod();
                sb.AppendLine(string.Format("Caller Module: {0}", mb.Module.FullyQualifiedName));
                sb.AppendLine(string.Format("Caller Class & Method: {0}.{1}()", mb.ReflectedType.FullName, mb.Name));
                sb.AppendLine(string.Format("File Info: Line {0} in {1}", sf.GetFileLineNumber(), sf.GetFileName()));
                sb.AppendLine(new string('=', 80));
            }
            catch (Exception ex) { logger_SystemError.Error(ex, "Exception"); }
            return sb.ToString();
        }

        public static void PrintPortCommandInfo(Port port)
        {
            try
            {
                string cmdStat = SCApplication.getMessageString("Port_CMD_Status_" + port.PortCommandStatus);
                string portStat = SCApplication.getMessageString("Port_Status_" + port.Port_Stat);
                Cassette cst = port.CassetteLoader.CassetteItem;
                string cstStat = string.Empty;
                string cstID = string.Empty;
                if (cst != null)
                {
                    cstStat = SCApplication.getMessageString("CST_Status_" + cst.CST_Stat);
                    if (!BCFUtility.isEmpty(cst.CST_ID))
                    {
                        cstID = cst.CST_ID;
                    }
                }
                StringBuilder sb = new StringBuilder();
                sb.AppendLine(string.Format("Port {0} [Command Status:{1}] [Port Status:{2}][CST ID:{3}][Cst Status:{4}]",
                    port.Port_ID.Trim(), cmdStat, portStat, cstID.Trim(), cstStat));
                CSTInfoLogger.Info(sb.ToString());
                sb.Clear();
            }
            catch (Exception ex)
            {
                CSTInfoLogger.Warn("SCUtility.PrintPortCommandInfo Occur Exception[{0}]", ex.ToString());
                logger_SystemError.Error(ex, "Exception");
            }
        }

        public static void PrintCSTInfo(CSTDataInfo cstInfo)
        {
            try
            {
                //SCApplication scApp = SCApplication.getInstance();
                //if (cstInfo == null) { return; }
                //StringBuilder sb = new StringBuilder();
                //sb.AppendLine();
                //sb.AppendLine(string.Format("{0}CST ID: {1}", new string(' ', 5), cstInfo.CST_ID));
                //sb.AppendLine(string.Format("{0}Port ID: {1}", new string(' ', 5), cstInfo.Port_ID));
                //sb.AppendLine(string.Format("{0}Port Type: {1}", new string(' ', 5), cstInfo.Port_Type));
                //sb.AppendLine(string.Format("{0}Port Use Type: {1}", new string(' ', 5), cstInfo.Port_Use_Type));
                //sb.AppendLine(string.Format("{0}Quantity: {1}", new string(' ', 5), cstInfo.Quantity));
                //sb.AppendLine(string.Format("{0}Slot Select: {1}", new string(' ', 5), cstInfo.Slot_Select));
                //if (cstInfo.GlassDataList != null)
                //{
                //    foreach (CSTDataInfo.GlassDataInfo glsInfo in cstInfo.GlassDataList)
                //    {
                //        sb.AppendLine(string.Format("{0}[Slot No: {1}][Glass ID: {2}][Lot ID: {3}]", new string(' ', 7), glsInfo.Slot_NO, glsInfo.Glass_ID, glsInfo.Lot_ID));
                //        sb.AppendLine(string.Format("{0}[Glass ID Type: {1}][Glass Type: {2}]", new string(' ', 10), glsInfo.Glass_ID_Type, glsInfo.Glass_Type));
                //        sb.AppendLine(string.Format("{0}[PPID: {1}][Sample Flag: {2}]", new string(' ', 10), glsInfo.PPID, glsInfo.Sample_Flag));
                //        EfemRecipe efemrecipe = getRecipeID(scApp, glsInfo.PPID);
                //        if (efemrecipe != null)
                //        {
                //            sb.AppendLine(string.Format("{0}[EFEM Recipe ID: {1}][Station1 EQ(Recipe ID): {2}({3})][Station2 EQ(Recipe ID): {4}({5})]"
                //                , new string(' ', 10), efemrecipe.Recipe_ID, efemrecipe.St1_Eq, efemrecipe.St1_Recipe, efemrecipe.St2_Eq, efemrecipe.St2_Recipe));
                //        }
                //        sb.AppendLine(string.Format("{0}[Work Order: {1}][Glass Grade: {2}]", new string(' ', 10), glsInfo.Work_Order, glsInfo.Glass_Grade));
                //        sb.AppendLine(string.Format("{0}[Glass Judge: {1}][Glass Size: {2}]", new string(' ', 10), glsInfo.Glass_Judge, glsInfo.Glass_Size));
                //        sb.AppendLine(string.Format("{0}[Glass THK: {1}][Lot Judge: {2}]", new string(' ', 10), glsInfo.Glass_THK, glsInfo.Lot_Judge));
                //        sb.AppendLine(string.Format("{0}[Maker: {1}][Mask ID: {2}]", new string(' ', 10), glsInfo.Maker, glsInfo.Mask_ID));
                //        sb.AppendLine(string.Format("{0}[Oper ID: {1}][Prober ID: {2}]", new string(' ', 10), glsInfo.Oper_ID, glsInfo.Prober_ID));
                //        sb.AppendLine(string.Format("{0}[Prod ID: {1}][Rework Count: {2}]", new string(' ', 10), glsInfo.Prod_ID, glsInfo.Rework_Count));
                //        sb.AppendLine(string.Format("{0}[Dummy Used Count: {1}][Exp Recipe ID: {2}]", new string(' ', 10), glsInfo.Dummy_Used_Count, glsInfo.Exp_Recipe_ID));
                //        sb.AppendLine(string.Format("{0}[Exp Unit ID: {1}]", new string(' ', 10), glsInfo.Exp_Unit_ID));
                //        sb.AppendLine(string.Format("{0}[Panel Judge: {1}]", new string(' ', 10), glsInfo.Panel_Judge));
                //        sb.AppendLine(string.Format("{0}[Array Repair Type: {1}]", new string(' ', 10), glsInfo.Array_Repair_Type));
                //        sb.AppendLine(string.Format("{0}[LCVD Repair Type: {1}]", new string(' ', 10), glsInfo.LCVD_Repair_Type));
                //    }
                //}
                //CSTInfoLogger.Info(sb.ToString());
                //sb.Clear();
            }
            catch (Exception ex)
            {
                CSTInfoLogger.Warn("SCUtility.PrintCSTInfo Occur Exception[{0}]", ex.ToString());
                logger_SystemError.Error(ex, "Exception");
            }
        }

        public static string PrintSortRule(SortRule[] sort_rule)
        {
            if (scApp == null) { scApp = SCApplication.getInstance(); }
            StringBuilder sb = scApp.stringBuilder.GetObject();
            string sRule = string.Empty;
            try
            {
                if (sort_rule == null) { return sRule; }
                sb.AppendLine();
                int sort_rule_count = sort_rule.Count();
                for (int i = 0; i < sort_rule_count; i++)
                {
                    sb.AppendLine(string.Format("{0}[Excuting: {1}]", new string(' ', 10), sort_rule[i].Excuting));
                    sb.AppendLine(string.Format("{0}[Source Port No: {1}][Target Port No: {2}]", new string(' ', 10), sort_rule[i].Source_Port_No, sort_rule[i].Target_Port_No));
                    sb.AppendLine(string.Format("{0}[Source Slot No: {1}][Target Slot No: {2}]", new string(' ', 10), sort_rule[i].Source_Slot_No, sort_rule[i].Target_Slot_No));
                }
                CSTInfoLogger.Info(sb.ToString());
                sRule = sb.ToString();
                sb.Clear();
                return sRule;
            }
            catch (Exception ex)
            {
                CSTInfoLogger.Error(ex, "SCUtility.PrintCSTInfo Occur Exception:");
                logger_SystemError.Error(ex, "Exception");
                return "Exception";
            }
            finally
            {
                scApp.stringBuilder.PutObject(sb);
            }
        }

        public static void PrintOperationLog(OperationHis opHis)
        {
            try
            {
                if (opHis == null) { return; }
                StringBuilder sb = new StringBuilder();
                sb.AppendLine();
                sb.AppendLine(string.Format("{0}Time: {1}", new string(' ', 5), opHis.T_Stamp));
                sb.AppendLine(string.Format("{0}User: {1}", new string(' ', 5), opHis.User_ID));
                sb.AppendLine(string.Format("{0}UI Name: {1}", new string(' ', 5), opHis.Form_Name));
                sb.AppendLine(string.Format("{0}Action: ", new string(' ', 5)));
                sb.AppendLine(string.Format("{0}         {1}", new string(' ', 5), opHis.Action));
                OperationLogger.Info(sb.ToString());
                sb.Clear();
            }
            catch (Exception ex)
            {
                OperationLogger.Warn("SCUtility.PrintOperationLog Occur Exception[{0}]", ex.ToString());
                logger_SystemError.Error(ex, "Exception");
            }
        }


        /// <summary>
        /// 根據傳入的IntAry轉出有號數的Int
        /// </summary>
        /// <param name="expandBitCnt"></param>
        /// <param name="targetType"></param>
        /// <param name="intAry"></param>
        /// <param name="multiplier"></param>
        /// <returns></returns>
        public static double convertInt2TextByType(int expandBitCnt, Type targetType, int[] intAry, double multiplier)
        {
            double doubleVal = 0;
            string bitsVal = string.Empty;
            bool sign = false;
            string tureValue = string.Empty;

            if (targetType.Equals(Type.GetType("System.Int16")))
            {
                bitsVal = Convert.ToString(intAry[0], 2).PadLeft(16, '0');

                sign = bitsVal[0] == '1';
                tureValue = bitsVal.Substring(1);
                Int16 val = Convert.ToInt16(tureValue, 2);
                if (sign)
                    doubleVal = -val * multiplier;
                else
                    doubleVal = val * multiplier;
            }
            else if (targetType.Equals(Type.GetType("System.Int32")))
            {
                bitsVal = Convert.ToString(intAry[0], 2).PadLeft(16, '0');
                if (intAry.Length > 1)
                {
                    bitsVal = string.Format("{0}{1}",
                        Convert.ToString(intAry[1], 2).PadLeft(16, '0'), bitsVal);
                }

                sign = bitsVal[0] == '1';
                tureValue = bitsVal.Substring(1);
                Int32 val = Convert.ToInt32(tureValue, 2);
                if (sign)
                    doubleVal = -val * multiplier;
                else
                    doubleVal = val * multiplier;

            }
            else if (targetType.Equals(Type.GetType("System.Int64")))
            {
                bitsVal = Convert.ToString(intAry[0], 2).PadLeft(16, '0');
                if (intAry.Length > 1)
                {
                    bitsVal = string.Format("{0}{1}",
                        Convert.ToString(intAry[1], 2).PadLeft(16, '0'), bitsVal);
                }
                if (intAry.Length > 2)
                {
                    bitsVal = string.Format("{0}{1}",
                        Convert.ToString(intAry[2], 2).PadLeft(16, '0'), bitsVal);
                }
                if (intAry.Length > 3)
                {
                    bitsVal = string.Format("{0}{1}",
                        Convert.ToString(intAry[3], 2).PadLeft(16, '0'), bitsVal);
                }

                sign = bitsVal[0] == '1';
                tureValue = bitsVal.Substring(1);
                Int64 val = Convert.ToInt64(tureValue, 2);
                if (sign)
                    doubleVal = -val * multiplier;
                else
                    doubleVal = val * multiplier;

            }

            return doubleVal;
        }

        /// <summary>
        /// 這個是根據KF欣興的LotID規則實現的Function，用以取得CJID的第3個-後的字串，無法取得則返回unknown-日期時間
        /// </summary>
        /// <param name="input"></param>
        /// <returns></returns>
        public static string GotLotIdFromCJID(string input)
        {
            if (string.IsNullOrEmpty(input))
                return "unknown-" + DateTime.Now.ToString("yyyyMMddHHmmss");

            // 計算破折號的數量和位置
            int dashCount = input.Count(c => c == '-');
            if (dashCount < 3)
                return "unknown-" + DateTime.Now.ToString("yyyyMMddHHmmss");

            // 找到第三個破折號的位置
            int thirdDashPosition = -1;
            int currentDash = 0;

            for (int i = 0; i < input.Length; i++)
            {
                if (input[i] == '-')
                {
                    currentDash++;
                    if (currentDash == 3)
                    {
                        thirdDashPosition = i;
                        break;
                    }
                }
            }

            // 返回第三個破折號後的所有內容
            return input.Substring(thirdDashPosition + 1);
        }

        /// <summary>
        /// 來用排序在DataGridView中呈現順序使用
        /// </summary>
        public class DisplayOrder : Attribute
        {
            public string ColumnName { get; set; }
            public int OrderNo { get; set; }

        }

        /// <summary>
        /// 控制是否允許存取資料庫的全域變數，同時也會控制 TraceDataReport Timer
        /// </summary>
        private static bool _allowDBAccess = true;
        public static bool AllowDBAccess
        {
            get { return _allowDBAccess; }
            set
            {
                if (_allowDBAccess != value)
                {
                    _allowDBAccess = value;

                    // 控制會存取資料庫相關的 Timer
                    ControlTimer("TraceDataReport", value);
                    ControlTimer("VersionDailyCheck", value);
                    ControlTimer("BindingProcessTimer", value);

                    OnDBAccessStateChanged?.Invoke(null, value);
                }
            }
        }

        /// <summary>
        /// 資料庫存取狀態改變事件
        /// </summary>
        public static event EventHandler<bool> OnDBAccessStateChanged;

        private static void ControlTimer(string timerName, bool enable)
        {
            var scApp = SCApplication.getInstance();
            if (scApp?.getBCFApplication() == null) return;

            var timer = scApp.getBCFApplication().getTimerAction(timerName);
            if (timer != null)
            {
                try
                {
                    if (enable)
                    {
                        timer.start();
                        logger.Info($"已恢復 {timerName} Timer");
                    }
                    else
                    {
                        timer.stop();
                        logger.Info($"已暫停 {timerName} Timer");
                    }
                }
                catch (Exception ex)
                {
                    logger_SystemError.Error(ex, $"控制 {timerName} Timer 時發生錯誤");
                }
            }
        }
    }

    public static class StringBuilderExtensions
    {
        public static void Add(this StringBuilder sb, string key, string value)
        {
            try
            {
                sb.AppendFormat("      {0} = {1}{2}"
                                , key
                                , value
                                , Environment.NewLine);
            }
            catch (Exception ex)
            {
                LogManager.GetLogger("SystemErrorLogger").Error("SCUtility has Error,  method：{0}、key:{1}、value:{2}、Exception Description:{3}",
                                                          "StringBuilderExtensions - Add",
                                                          key,
                                                          value,
                                                          ex.ToString());
            }
        }
    }
}