﻿//*********************************************************************************
//      uc_Maintenance.cs
//*********************************************************************************
// File Name: uc_PortSetting.cs
// Description: Port維護介面
//
//(c) Copyright 2014, MIRLE Automation Corporation
//
// Date               Author            Request No.       Tag        Description
// ---------------   ---------------   ---------------   --------   ---------------
// 2022/07/05         Xenia Tseng       N/A               N/A        Initial。
//*********************************************************************************
using BlockControl_3._0_WPF.frm_Help;
using com.mirle.ibg3k0.bc.winform.App;
using com.mirle.ibg3k0.bc.winform.Data.VO;
using com.mirle.ibg3k0.bcf.Common;
using com.mirle.ibg3k0.sc.App;
using com.mirle.ibg3k0.sc.Common;
using com.mirle.ibg3k0.sc.Data.ValueDefMapAction;
using com.mirle.ibg3k0.sc.Data.VO;
using NLog;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Markup;

namespace BCWPF.frm_Query
{
    /// <summary>
    /// uc_AlarmInformation.xaml 的互動邏輯
    /// </summary>
    public partial class uc_PortSetting : UserControl
    {
        #region 全域變數
        public event EventHandler btn_Close_Click;
        BCApplication bcApp = null;
        SCApplication scApp = null;
        private static Logger logger = LogManager.GetCurrentClassLogger();
        protected static Logger logger_SystemError = LogManager.GetLogger("SystemErrorLogger");
        frm_TipMessage_OK tipmsg_ok = new frm_TipMessage_OK("");        //A0.01
        frm_TipMessage_YesNo tipmsg = new frm_TipMessage_YesNo("");
        Line line = new Line();
        string colorVersion = string.Empty;
        string languageVersion = string.Empty;
        bool visibleFlag = false;
        private PortDefaultValueDefMapAction portMapAction = null;
        Port port;
        List<string> portIDlist = new List<string>();
        List<string> portEQIDlist = new List<string>();
        #endregion 全域變數


        //建構子
        public uc_PortSetting()
        {
            InitializeComponent();
            bcApp = BCApplication.getInstance();
            scApp = SCApplication.getInstance();
            line = scApp.getEQObjCacheManager().getLine();
            List<Port> portlist = scApp.getEQObjCacheManager().getAllPort();
            foreach (Port p in portlist)
            {
                string type = string.Empty;
                //if (scApp.BC_ID == SCAppConstants.EFEMID_INITIAL_CLEAN)
                //{
                //    EqptMap eqptMap = scApp.EqptMapDao.getByEFEM_ID(p.Eqpt_ID, SCAppConstants.EFEMID_INITIAL_CLEAN);
                //    if (eqptMap != null)
                //    {
                //        if (eqptMap.EQPT_REAL_ID.Contains("LD"))
                //        {
                //            type = "_LD";
                //        }
                //        else
                //        {
                //            type = "_ULD";
                //        }
                //    }
                //}
                portIDlist.Add(p.Port_ID + type);
                portEQIDlist.Add(p.Eqpt_ID);
            }
        }

        private void UC_VisibleChanged(object sender, DependencyPropertyChangedEventArgs e)
        {
            try
            {
                if ((bool)e.NewValue)
                {
                    // 載入 Port 列表
                    LoadPortList();
                    
                    // 如果有資料，選擇第一筆
                    if (cmb_PortList.Items.Count > 0)
                    {
                        cmb_PortList.SelectedIndex = 0;
                    }
                }
            }
            catch (Exception ex)
            {
                logger_SystemError.Error(ex, "Exception in UC_VisibleChanged");
            }
        }

        private void LoadPortList()
        {
            try
            {
                cmb_PortList.Items.Clear();
                var portList = scApp.getEQObjCacheManager().getAllPort();
                if (portList != null)
                {
                    foreach (var port in portList)
                    {
                        cmb_PortList.Items.Add(port.Port_ID);
                    }
                }
            }
            catch (Exception ex)
            {
                logger_SystemError.Error(ex, "Exception in LoadPortList");
            }
        }

        private void refreshUI()
        {
            try
            {
                this.Dispatcher.Invoke(() =>
                {
                    cmb_PortList.ItemsSource = null;
                    cmb_PortList.ItemsSource = portIDlist;
                });
            }
            catch (Exception ex)
            {
                logger_SystemError.Error(ex, "Exception in refreshUI");
            }
        }

        private void Close_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                if (btn_Close_Click != null)
                {
                    btn_Close_Click(sender, e);
                }
            }
            catch (Exception ex)
            {
                logger_SystemError.Error(ex, "Exception");
            }
        }

        //private void Light_Click(object sender, RoutedEventArgs e)
        //{
        //    try
        //    {
        //        //亮色系
        //        if (SCUtility.isMatche(colorVersion, "Light"))
        //        {
        //            return;
        //        }
        //        //暗色系
        //        else
        //        {
        //            //檢查語系，改顏色不能更動到語系
        //            switch (languageVersion)
        //            {
        //                case "EN":
        //                    ChangeSkin("Skins/MirleGo_EN_Light.xaml");
        //                    line.SkinMode = "MirleGo_EN_Light";
        //                    break;
        //                case "TW":
        //                    ChangeSkin("Skins/MirleGo_TW_Light.xaml");
        //                    line.SkinMode = "MirleGo_TW_Light";
        //                    break;
        //                default:
        //                    break;
        //            }
        //        }
        //        refreshUI();
        //    }
        //    catch (Exception ex)
        //    {
        //        logger_SystemError.Error(ex, "Exception");
        //    }
        //}

        //private void Dark_Click(object sender, RoutedEventArgs e)
        //{
        //    try
        //    {
        //        //暗色系
        //        if (SCUtility.isMatche(colorVersion, "Dark"))
        //        {
        //            return;
        //        }
        //        //亮色系
        //        else
        //        {
        //            //檢查語系，改顏色不能更動到語系
        //            switch (languageVersion)
        //            {
        //                case "EN":
        //                    ChangeSkin("Skins/MirleGo_EN_Dark.xaml");
        //                    line.SkinMode = "MirleGo_EN_Dark";
        //                    break;
        //                case "TW":
        //                    ChangeSkin("Skins/MirleGo_TW_Dark.xaml");
        //                    line.SkinMode = "MirleGo_TW_Dark";
        //                    break;
        //                default:
        //                    break;
        //            }
        //        }
        //        refreshUI();
        //    }
        //    catch (Exception ex)
        //    {
        //        logger_SystemError.Error(ex, "Exception");
        //    }
        //}

        //void ChangeSkin(string skinRelativeUri)
        //{
        //    var si = Application.GetContentStream(new Uri(skinRelativeUri, UriKind.Relative));
        //    if (si == null) return;
        //    var rd = (ResourceDictionary)XamlReader.Load(si.Stream);
        //    Application.Current.Resources.MergedDictionaries.Clear();
        //    Application.Current.Resources.MergedDictionaries.Add(rd);
        //}

        private void getPortObject(object sender, SelectionChangedEventArgs e)
        {
            try
            {
                //btn_Set.IsEnabled = false;

                if (cmb_PortList.SelectedItem != null)
                {
                    string portid = cmb_PortList.SelectedItem.ToString();
                    port = scApp.getEQObjCacheManager().getPortByPortID(portid);
                    if (port != null)
                    {
                        portMapAction = port.getMapActionByIdentityKey(nameof(PortDefaultValueDefMapAction)) as PortDefaultValueDefMapAction;
                    }

                    if (port.Port_Enable == SCAppConstants.PortEnable.Enable)
                    {
                        rdb_portEnable.IsChecked = true;
                    }
                    else if(port.Port_Enable == SCAppConstants.PortEnable.Disable)
                    {
                        rdb_portDisable.IsChecked = true;
                    }
                    else
                    {
                        rdb_portEnable.IsChecked = false; 
                        rdb_portDisable.IsChecked = false;
                    }

                    if (port.Port_Accessmode == SCAppConstants.PortAccessMode.Auto) //Auto
                    {
                        rdb_portAuto.IsChecked = true;
                    }
                    else if (port.Port_Accessmode == SCAppConstants.PortAccessMode.Manual) //Manual
                    {
                        rdb_portManual.IsChecked = true;
                    }
                    else
                    {
                        rdb_portAuto.IsChecked = false;
                        rdb_portManual.IsChecked = false;
                    }

                    if (port.Port_Type == SCAppConstants.PortType.LD)
                    {
                        rdb_load.IsChecked = true;
                    }
                    else if (port.Port_Type == SCAppConstants.PortType.ULD)
                    {
                        rdb_unLoad.IsChecked = true;
                    }else if(port.Port_Type == SCAppConstants.PortType.LD_ULD)
                    {
                        rdb_loadUnload.IsChecked = true;
                    }
                    else
                    {
                        rdb_unLoad.IsChecked = false;
                        rdb_loadUnload.IsChecked = false;
                        rdb_load.IsChecked = false;
                    }
                }
                else
                {
                    rdb_portEnable.IsChecked = false;
                    rdb_portDisable.IsChecked = false; 
                    rdb_portAuto.IsChecked = false;
                    rdb_portManual.IsChecked = false;
                    rdb_unLoad.IsChecked = false;
                    rdb_loadUnload.IsChecked = false;
                    rdb_load.IsChecked = false;
                }
            }
            catch (Exception ex)
            {
                logger_SystemError.Error(ex, "Exception");
            }
        }

        private void Set_Click(object sender, RoutedEventArgs e)
        {
            try
            {
            
                bool sPortEnable;
                bool sPortAccess;
                int iPortType;
                var PortEnableGroup = g_portEnable.Children.OfType<RadioButton>()?.FirstOrDefault(x => x.IsChecked.Value);
                var PortAccessGroup = g_portAccessMode.Children.OfType<RadioButton>()?.FirstOrDefault(x => x.IsChecked.Value);
                var PortTypeGroup = g_portType.Children.OfType<RadioButton>()?.FirstOrDefault(x => x.IsChecked.Value);

                this.Dispatcher.Invoke(() =>
                {
                    btn_Set.IsEnabled = false;
                });

                // 確認對話框
                string confirmMessage = line.SkinMode.Substring(8, 2) == "TW" ?
                    "請確認是否要套用此設定？\nDo you want to apply these settings?" :
                    "Do you want to apply these settings?\n請確認是否要套用此設定？";
                tipmsg = new frm_TipMessage_YesNo(confirmMessage);
                tipmsg.ShowDialog();
                if (tipmsg.bResult != true)
                {
                    refreshUI();
                    this.Dispatcher.Invoke(() =>
                    {
                        btn_Set.IsEnabled = true;
                    });
                    return;
                }

                #region 檢查radio button是否有被勾選
                if (PortEnableGroup == null || PortAccessGroup == null || PortTypeGroup == null)
                {
                    string errorMessage = string.Empty;
                    if (PortEnableGroup == null)
                    {
                        errorMessage = "請選擇 Port 啟用/停用狀態。\nPlease select port enable/disable status.";
                    }
                    else if (PortAccessGroup == null)
                    {
                        errorMessage = "請選擇 Port 存取模式。\nPlease select port access mode.";
                    }
                    else if (PortTypeGroup == null)
                    {
                        errorMessage = "請選擇 Port 類型。\nPlease select port type.";
                    }
                    tipmsg_ok.setMessage(errorMessage);
                    tipmsg_ok.ShowDialog();
                    refreshUI();
                    this.Dispatcher.Invoke(() =>
                    {
                        btn_Set.IsEnabled = true;
                    });
                    return;
                }
                #endregion

                if (portMapAction != null)
                {
                    sPortEnable = rdb_portEnable.IsChecked == true ? true : false; //1: Enable, 0: Disable
                    sPortAccess = rdb_portAuto.IsChecked == true ? true : false; //2: Auto, 1: Manual
                    if (rdb_load.IsChecked == true)
                    {
                        iPortType = SCAppConstants.PortType.LD;
                    }
                    else if(rdb_unLoad.IsChecked == true)
                    {
                        iPortType = SCAppConstants.PortType.ULD;
                    }
                    else if(rdb_loadUnload.IsChecked == true)
                    {
                        iPortType = SCAppConstants.PortType.LD_ULD;
                    }
                    else
                    {
                        iPortType = SCAppConstants.PortType.No_Used;
                    }

                    SCApplication.getMessageString("Port_Access_Mode_A");
                    SCApplication.getMessageString("PortEnable_" + sPortEnable);

                    if (PortEnableGroup != null && PortAccessGroup != null && PortTypeGroup != null)
                    {
                        if (portMapAction.HP03_PortEnableAccessModeChangeReq(sPortEnable, sPortAccess, iPortType))
                        {
                            string successMessage = "設定已成功套用。\nSettings have been successfully applied.";
                            tipmsg_ok.setMessage(successMessage);
                            tipmsg_ok.ShowDialog();
                        }
                        else
                        {
                            string errorMessage = "設定套用失敗。\n" +
                                                "可能原因：\n" +
                                                "1. Port 正在執行中\n" +
                                                "2. PLC通訊異常\n" +
                                                "請稍後再試或聯絡系統管理員。\n\n" +
                                                "Settings application failed.\n" +
                                                "Possible reasons:\n" +
                                                "1. Port is in operation\n" +
                                                "2. PLC Communication error\n" +
                                                "Please try again later or contact system administrator.";
                            tipmsg_ok.setMessage(errorMessage);
                            tipmsg_ok.ShowDialog();
                        }

                        string sPortEnable_Content;
                        string sPortAccess_Content;
                        string action = string.Format("Set Port ID:[{0}], Enable/Disable:[{1}], Access Mode:[{2}], Result:[{3}].", port.Port_ID,
                                                   sPortEnable_Content = (sPortEnable == false) ? "0: Disable" : "1: Enable",
                                                   sPortAccess_Content = (sPortAccess == true) ? "2: Auto" : "1: Manual",
                                                   tipmsg_ok.tbk_Message.Text);
                        
                        this.Dispatcher.Invoke(() =>
                        {
                            bcApp.SCApplication.BCSystemBLL.addOperationHis(bcApp.LoginUserID, this.Name, action);
                        });
                    }
                }
                refreshUI();
                
                this.Dispatcher.Invoke(() =>
                {
                    btn_Set.IsEnabled = true;
                });
            }
            catch (Exception ex)
            {
                logger_SystemError.Error(ex, "Exception in Set_Click");
                string errorMessage = "設定過程中發生未預期的錯誤。\n" +
                                    "請聯絡系統管理員。\n\n" +
                                    "An unexpected error occurred during settings application.\n" +
                                    "Please contact system administrator.";
                tipmsg_ok.setMessage(errorMessage);
                tipmsg_ok.ShowDialog();
                this.Dispatcher.Invoke(() =>
                {
                    btn_Set.IsEnabled = true;
                });
            }
        }
    }
}
